// Plik implementacji klasy Rectangle
#include "Rectangle.h" // Instrukcja wymagana przez klasę Rectangle
#include <iostream>    // Instrukcja wymagana przez obiekt cout
#include <cstdlib>     // Instrukcja wymagana przez funkcję exit()
using namespace std;

//***********************************************************
// Funkcja setWidth() przypisuje wartość zmiennej członkowskiej width.
//***********************************************************

void Rectangle::setWidth(double w)
{
  if (w >= 0)
    width = w;
  else
  {
    cout << "Błędna szerokość\n";
    exit(EXIT_FAILURE);
  }
}

//***********************************************************
// Funkcja setLength() przypisuje wartość zmiennej członkowskiej length.
//***********************************************************

void Rectangle::setLength(double len)
{
  if (len >= 0)
    length = len;
  else
  {
    cout << "Błędna długość\n";
    exit(EXIT_FAILURE);
  }
}

//************************************************************
// Funkcja getWidth() zwraca wartość zmiennej członkowskiej width.
//************************************************************

double Rectangle::getWidth() const
{
  return width;
}

//**************************************************************
// Funkcja getLength() zwraca wartość zmiennej członkowskiej getLength.
//**************************************************************

double Rectangle::getLength() const
{
  return length;
}

//************************************************************
// Funkcja getArea() zwraca iloczny zmiennych width i length.
//************************************************************

double Rectangle::getArea() const
{
  return width * length;
}
